![[Pasted image 20250428135401.png]]
## Introduction to Authentication, Authorization, and Accounting (AAA)
- **Purpose**:
    - Enforces privilege-based access.
    - Tracks user activities.
    - Enables collaboration while controlling non-productive activities.
- **Cisco Secure Web Appliance Support**:
    - Wide range of authentication mechanisms.
    - Tracks users by username instead of IP address.
    - Integrates with existing authentication infrastructures (e.g., Active Directory, Cisco ISE).

---
## Authentication Features

- **Requirements**:
    - Provide differentiated policies for users and groups.
    - Track and log employee internet usage.
- **Capabilities**:
    - Enforce distinct policies for identity, roles, and groups.
    - Restrict specific user agents (browsers) or protocols.

---
## Authentication Methods

### **Authentication Modes**:
1. **Explicit Forward Proxy Mode**:
    - User is aware of the proxy.
    - Directly prompts for credentials via HTTP 407 authentication requests.
    - Easier to troubleshoot authentication issues.
2. **Transparent Proxy Mode**:
    - User is unaware of the proxy.
    - Proxy spoofs the web server and sends HTTP 401 authentication requests.
    - Requires redirection via network devices like WCCP or PBR.

### **Types of Authentication**:
1. **Active Authentication**:
    - Prompts users for credentials.
    - Verifies against external servers (e.g., Active Directory or LDAP).
2. **Passive Authentication**:
    - Transparent, with no user prompts.
    - Relies on external sources like Cisco ISE for IP-user mapping.

---
## Authentication Protocols and Schemes

- **Protocols**:
    1. **NTLM** (Microsoft proprietary): Commonly used with Active Directory.
    2. **LDAP**: Used with basic authentication only.
- **Schemes Supported by NTLM**:
    - **Kerberos**: Secure, high performance, supports single sign-on (SSO).
    - **NTLMSSP**: Challenge-response mechanism, moderate overhead.
    - **Basic Authentication**: Simple, but sends credentials in cleartext.

---

## Single Sign-On (SSO)

- **Kerberos**: Provides true SSO in Active Directory environments.
- **NTLMSSP**: Enables Windows login credentials for seamless authentication.
- **Benefits**:
    - Reduces user confusion.
    - Credentials are transparently provided to the proxy.

---

## Authentication Realms

- **Definition**: A set of authentication servers supporting a single protocol.
- **Features**:
    - Multiple realms (e.g., LDAP, Active Directory) can be created.
    - Realms grouped into sequences for prioritization and policy application.
- **Use Cases**:
    - Configured within identification profiles and policy groups.

---

## Cisco ISE Integration

- **Features**:
    - Transparent user authentication using Cisco ISE and IEEE 802.1X.
    - IP-user mapping via Cisco pxGrid for policy enforcement.
    - Assigns Scalable Group Tags (SGTs) for access control.
- **Benefits**:
    - Centralized user and device management.
    - Enhanced identity and web security policies.

---

## Authentication and Reauthentication Features

- **Bypassing Authentication**:
    - Required for applications that don’t support authentication (e.g., updates or certain client apps).
    - Identification profiles can allow bypassing authentication for specific user agents.
- **Reauthentication**:
    - Triggered by restrictive URL filtering policies (not malware or reputation blocks).
    - Allows users to log in with a higher-privileged account when access is denied.
    - Common in shared environments (e.g., libraries, hospitals).

---

## Tracking User Credentials

### **Authentication Surrogates**:

1. **Cookies**:
    - Best for environments with dynamic IPs or Citrix environments.
    - Can be session-based or persistent.
2. **IP Address**:
    - Suitable for HTTPS and custom applications that don’t support cookies.
    - Tracks users by IP, but less secure for multi-user environments.
3. **No Surrogate**:
    - Prompts users for credentials for every new TCP connection (explicit mode only).

---

## Comparison of Proxy Modes

- **Explicit Proxy Mode**:
    - User is aware of the proxy and accepts HTTP 407 authentication requests.
    - Best for environments where user configuration is feasible.
- **Transparent Proxy Mode**:
    - Proxy spoofs the web server and uses HTTP 401 requests for authentication.
    - Requires network device redirection (e.g., WCCP).
    - Ideal for environments where user configuration is not possible.

---

## Key Takeaways

- **Cisco Secure Web Appliance**:
    - Offers flexible authentication methods (active/passive).
    - Supports multiple authentication protocols (NTLM, LDAP).
    - Integrates with Cisco ISE for enhanced identity and access management.
- **Authentication Modes**:
    - Explicit: Direct user interaction, simpler troubleshooting.
    - Transparent: User unaware, requires network redirection.
- **Tracking Mechanisms**:
    - Cookies: Ideal for dynamic IP environments.
    - IP Address: Suitable for HTTPS and non-cookie applications.

